/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.utility.printing;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Objects;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;

public final class JsonPrinter
implements PrettyPrinter.IPrettyPrintable {
    private final JsonElement json;

    public JsonPrinter(JsonElement json) {
        this.json = json;
    }

    @Override
    public void print(PrettyPrinter printer) {
        String raw = new GsonBuilder().setPrettyPrinting().create().toJson(this.json);
        for (String line : raw.split("\n")) {
            printer.add(line);
        }
    }

    public JsonElement json() {
        return this.json;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        JsonPrinter that = (JsonPrinter)obj;
        return Objects.equals(this.json, that.json);
    }

    public int hashCode() {
        return Objects.hash(this.json);
    }

    public String toString() {
        return "JsonPrinter[json=" + String.valueOf(this.json) + "]";
    }
}

